import { IActionParam, IParam, MainControl, deepCopy, isExistAndNotEmpty, UIUtil } from "@core";
import { ExpBarControlProps } from "./exp-bar-control-prop";
import { ExpBarControlState } from "./exp-bar-control-state";

/**
 * @description 导航栏部件
 * @export
 * @class ExpBarControl
 * @extends {MainControl}
 */
export class ExpBarControl extends MainControl {
  /**
   * @description 部件状态
   * @type {ExpBarControlState}
   * @memberof ExpBarControl
   */
  public declare state: ExpBarControlState;

  /**
   * 部件输入参数
   *
   * @type {ExpBarControlProps}
   * @memberof ExpBarControl
   */
  public declare props: ExpBarControlProps;

  /**
   * 通知状态
   *
   * @param { tag: string, action: string, data: any } { tag, action, data }
   * @memberof ViewEngine
   */
  public next({ tag, action, data }: { tag: string, action: string, data: any }): void {
    const { viewSubject } = this.state;
    viewSubject.next({ tag: tag, action: action, data: data })
  }

  /**
   * 搜索
   *
   * @param {*} value
   * @param {MouseEvent} event
   * @memberof TreeExpBarControl
   */
  public search(value: any, event: MouseEvent) { }

  /**
   * 使用搜索模块
   *
   * @protected
   * @return {*} 
   * @memberof TreeExpBarControl
   */
  protected useSearch() {
    const search = (value: any, event: MouseEvent) => {
      if (this.xDataControl) {
        this.next({ tag: this.xDataControl.name, action: 'load', data: { query: value } });
      }
    }
    this.search = search;
    return search;
  }

  /**
   * @description 导航部件初始化
   * @protected
   * @memberof ExpBarControl
   */
  protected useExpCtrlInit() {
    onMounted(() => {
      if (this.xDataControl) {
        this.next({ tag: this.xDataControl.name, action: 'load', data: null });
      }
    })
  }

  /**
   * @description 处理部件事件
   * @param {IActionParam} actionParam
   * @memberof ExpBarControl
   */
  public onCtrlEvent(actionParam: IActionParam) {
    const { tag, action, data } = actionParam;
    switch (action) {
      case 'selectionChange':
        this.onSelectionChange(data);
        break;
    }
  }

  /**
   * 工具栏事件
   *
   * @param {IActionParam} actionParam
   * @return {*} 
   * @memberof ExpBarControl
   */
  public onToolbarEvent(actionParam: IActionParam) {
    const { data } = actionParam;
    if (!data) {
      console.warn("工具栏事件执行参数不足");
      return;
    }
    const { uIAction } = data;
    if (!uIAction) {
      console.warn("工具栏事件执行参数不足");
      return;
    }
    const inputParam = {
      context: this.state.context,
      viewParams: this.state.viewParams,
      data: this.getData(),
      event: data.event,
      actionEnvironment: this
    }
    App.getAppActionService().execute(uIAction, inputParam);
  }

  /**
   * @description 处理选中事件
   * @protected
   * @param {any[]} data
   * @memberof ExpBarControl
   */
  protected onSelectionChange(data: any[]) {
    //  无选中数据不处理
    if (data.length === 0) {
      this.calcToolbarItemState(true);
      return;
    }
    //  选中数据
    const arg: IParam = data[0];
    if (!this.xDataControl || !this.xDataControl.state) {
      console.warn('未获取到数据部件');
      return;
    }
    //  上下文和视图参数
    const tempContext = deepCopy(this.state.context);
    const tempViewParams = deepCopy(this.state.viewParams);
    const appDeCodeName: string = this.xDataControl.state.appDeCodeName?.toLowerCase() || '';
    //  数据主键
    const parentKey: any = appDeCodeName && isExistAndNotEmpty(arg[appDeCodeName]) ? arg[appDeCodeName] : arg.srfkey;
    if (isExistAndNotEmpty(appDeCodeName)) {
      Object.assign(tempContext, {
        [appDeCodeName]: parentKey,
        srfparentdename: appDeCodeName,
        srfparentdemapname: this.xDataControl.state.deName,
        srfparentkey: parentKey
      });
      const { navFilter, navPSDer, navigateContext, navigateParams } = this.state;
      //  导航过滤项
      if (navFilter) {
        Object.assign(tempViewParams, { [navFilter]: parentKey });
      }
      //  导航关系
      if (navPSDer) {
        Object.assign(tempViewParams, { [navPSDer]: parentKey });
      }
      //  导航上下文
      if (navigateContext) {
        const _context = UIUtil.computedNavData(arg, this.state.context, this.state.viewParams, navigateContext);
        Object.assign(tempContext, _context);
      }
      //  导航视图参数
      if (navigateParams) {
        const _params = UIUtil.computedNavData(arg, this.state.context, this.state.viewParams, navigateParams);
        Object.assign(tempViewParams, _params);
      }
    }
    const { selection } = toRefs(this.state);
    Object.assign(selection.value, {
      context: tempContext,
      key: parentKey ? parentKey : this.state.navViewName,
      viewParams: tempViewParams
    });
    this.calcToolbarItemState(false);
  }

  /**
   * @description 计算工具栏权限
   * @param {boolean} state
   * @memberof ExpBarControl
   */
  public calcToolbarItemState(state: boolean) {
    //  TODO 计算工具栏权限
    // let _this: any = this;
    // const models: any = _this.toolbarModels;
    // if (models && models.length > 0) {
    //   for (const key in models) {
    //     if (!models.hasOwnProperty(key)) {
    //       return;
    //     }
    //     const _item = models[key];
    //     if (_item.uiaction && (Object.is(_item.uiaction.actionTarget, 'SINGLEKEY') || Object.is(_item.uiaction.actionTarget, 'MULTIKEY'))) {
    //       _item.disabled = state;
    //     }
    //     _item.visabled = true;
    //     if (_item.noprivdisplaymode && _item.noprivdisplaymode === 6) {
    //       _item.visabled = false;
    //     }
    //   }
    //   this.calcNavigationToolbarState();
    // }
  }

  /**
   * @description 计算导航栏工具栏权限
   * @memberof ExpBarControl
   */
  public calcNavigationToolbarState() {
    let _this: any = this;
    if (_this.toolbarModels) {
      // ViewTool.calcActionItemAuthState({}, this.toolbarModels, this.appUIService);
    }
  }

  /**
  * @description 安装部件所有功能模块的方法
  * @return {*}
  * @memberof ExpBarControl [emit] 事件
  */
  public moduleInstall() {
    const superParams = super.moduleInstall();
    this.useExpCtrlInit();
    return {
      ...superParams,
      search: this.useSearch(),
      onToolbarEvent: this.onToolbarEvent.bind(this)
    };
  }
}